<?php

namespace Txd\FieldTypes;

class Decimal extends \Txd\FieldTypes\Number
{
    public function __construct($nome, $etichetta = '', $classi_html = [])
    {
        parent::__construct($nome, $etichetta, $classi_html);
        $this->precision(2);
    }

    protected int $precision;

    /**
     * @return this|null
     */
    public function precision(?int $value = null)
    {
        if (is_null($value)) {
            return $this->precision;
        }

        $this->precision = $value;

        $this->htmlProperties()->addHtmlAttribute('step', (string) (1 / pow(10, $this->precision)));

        return $this;
    }

    protected int $min;

    /**
     * @return this|null
     */
    public function min(?int $value = null)
    {
        if (is_null($value)) {
            return $this->min;
        }
        $this->min = $value;
        $this->htmlProperties()->addHtmlAttribute('min', $this->min);
        $this->addRule("min:$value");

        return $this;
    }

    protected int $max;

    /**
     * @return this|null
     */
    public function max(?int $value = null)
    {
        if (is_null($value)) {
            return $this->max;
        }
        $this->max = $value;
        $this->htmlProperties()->addHtmlAttribute('max', $this->max);
        $this->addRule("max:$value");

        return $this;
    }

    public static string $global_decimal_separator = ',';

    protected ?string $decimal_separator = null;

    /**
     * @return this|null
     */
    public function decimal_separator(?string $value = null)
    {
        if (is_null($value)) {
            return $this->decimal_separator;
        }
        $this->decimal_separator = $value;

        return $this;
    }

    public static string $global_thousands_separator = '.';

    protected ?string $thousands_separator = null;

    /**
     * @return this|null
     */
    public function thousands_separator(?string $value = null)
    {
        if (is_null($value)) {
            return $this->thousands_separator;
        }
        $this->thousands_separator = $value;

        return $this;
    }

    public function parse_valore($valore)
    {

        if (is_null($valore)) {
            return $valore;
        }

        return number_format($valore, $this->precision, $this->decimal_separator ?? static::$global_decimal_separator, $this->thousands_separator ?? static::$global_thousands_separator);

    }
}
