<?php

namespace Txd\Traits;

use Txd\Facades\DbFields;
use Txd\txdFields;

trait txdModel
{
    protected ?txdFields $db_fields = null;

    /**
     * abilita la costruzione del nome campo complesso
     *
     * @var bool
     */
    public $txdPrefixEnable = false;

    /**
     * Experimental: flag per abilitare il caching dei campi
     *
     * @var bool
     */
    public $cache_enabled = false;

    /**
     * popola l'elenco degli attributi legati al database
     *
     * [placeholder da sostituire con i campi che verranno poi stampati nel form]
     */
    public function init_db_fields($sectors = null)
    {
        if (!is_null($sectors)) {
            $this->db_fields = null;
            if (is_string($sectors)) {
                $sectors = [$sectors];
            }
        } else {
            $sectors = [];
        }
        if (is_null($this->db_fields)) {
            $db_fields = $this->cache_enabled ? cache('db_fields.'.static::class) : null;
            if (is_null($db_fields)) {
                $db_fields = new txdFields($this);
                $this->set_db_fields($db_fields);
                DbFields::pushInstance($db_fields);

                $this->db_fields_definition($db_fields);
                $db_fields->sort();
                DbFields::popInstance();
                $this->cache_enabled ? cache(['db_fields.'.static::class => $db_fields], now()->addSeconds(30)) : '';
            } else {
                $this->set_db_fields($db_fields);
            }
            if (count($sectors) > 0) {
                $this->db_fields = $db_fields->reduce($sectors, true);
            }
        }
    }

    /**
     * imposta l'attributo locale db_fields
     */
    public function set_db_fields(txdFields $txdField)
    {
        $this->db_fields = $txdField;
    }

    /**
     * funzione per isolamento configurazione db_fields da codice boilerplate.
     * deve essere ridefinita nel modello. Se nel modello è stata ridefinita init_db_fields classico questo metodo non viene invocato
     *
     * @param  \Txd\txdFields  $db_fields  elemento da configurare
     * @return void
     */
    public function db_fields_definition($db_fields) {}

    public function fields(): txdFields
    {

        $this->init_db_fields(); //cosi' che venga sempre popolato l'array anche se non fosse ancora stato chiamato

        return $this->db_fields;
    }

    public function formValues($raw = false)
    {
        $out = [];
        foreach ($this->get_campi() as $key => $field) {
            $label = $key;

            $out[$label] = $field->get_valore($raw);
        }

        return $out;
    }

    /**
     * recupera tutti i campi di un determinato settore (o tutti in caso di NULL come parametro)
     *
     * @param  array|string  $settori,...  nome del settore o array vuoto per tutti i settori
     * @return \Txd\txdFields elenco degli attributi del settore richiesto
     */
    public function get_campi($settori = [])
    {

        if (is_string($settori)) {
            $settori = [$settori];
        }
        $this->init_db_fields(); //cosi' che venga sempre popolato l'array anche se non fosse ancora stato chiamato
        $new = $this->db_fields->reduce($settori, true);
        $new->source = $settori;

        return $new;

    }

    /**
     * ritorna un oggetto \Txd\txdFields con campi inizializzati secondo i settori passati, agganciato ad una entità nuova (new)
     *
     * @param  array|string  $settori
     * @return \Txd\txdFields
     */
    public static function get_campi_statici($settori = [])
    {

        if (is_string($settori)) {
            $settori = [$settori];
        }
        $obj = new static;
        $obj->init_db_fields($settori);

        return $obj->get_campi();

    }

    public static function scopeWithPermissions($builder, $user_obj = null, $forceConstraints = false)
    {
        $callback = function () use ($builder, $user_obj) {
            $nome_classe = get_class($builder->getModel());
            $nome_classe::applica_permessi($builder, $user_obj);

            return $builder;
        };

        if ($forceConstraints) {
            return \Txd\Relations\Relation::withConstraints($callback);
        } else {
            return $callback();
        }
    }

    public static function scopeWithRelationPermissions($builder, $user_obj = null, $forceConstraints = false)
    {
        if (!config('txd_fieldtypes.evaluate_permissions_in_relations', true)) {
            return $builder;
        }

        return static::scopeWithPermissions($builder, $user_obj, $forceConstraints);
    }

    public static function scopeApplicaPermessi($builder, $user_obj = null, $forceConstraints = false)
    {
        return static::scopeWithPermissions($builder, $user_obj, $forceConstraints);
    }
}
