<?php

namespace Txd\FieldTypes;

/**
 * Tipo txdAttributes per datatime
 */
class Datetime extends Text
{
    public $parse_options = [];

    public function __construct($nome, $etichetta = '', $classi_html = [])
    {
        parent::__construct($nome, $etichetta, $classi_html);
        $this->optFormat(config('par.datetime_format'));
        $this->htmlProperties()->addHtmlClass('datatime_picker');
    }

    public function parse_valore($valore)
    {

        $value = carbonStampaData($valore, $this->parse_options);

        $re = '/^\d+$/';
        if (preg_match($re, $value) === 1) {
            $value = (int) $value;
        }

        return $value;
    }

    public function optFormat(string $format)
    {
        $this->parse_options['format'] = $format;

        return $this;
    }

    public function withSeconds($value = true)
    {
        if ($value) {
            $this->htmlProperties()->addHtmlAttribute('data-no-seconds');
        } else {
            $this->htmlProperties()->removeHtmlAttribute('data-no-seconds');
        }
    }

    public function tipo_campo_form()
    {
        return 'parse_value';
    }

    public function build_edit()
    {

        return view('txd::FieldTypes.Datetime', ['campo_obj' => $this]);
    }
}
