<?php

namespace Txd\Traits;

use Illuminate\Support\Facades\Validator;
use Illuminate\Support\MessageBag;

trait ValidatingTrait
{
    protected $errors = null;

    public function getRules()
    {
        return $this->model_rules;
    }

    public function isValid()
    {
        $validator = Validator::make($this->attributes, $this->getRules());
        if ($validator->fails()) {
            $this->errors = $validator->errors();

            return false;
        }

        return true;
    }

    public function getErrors(): ?MessageBag
    {
        return $this->errors;
    }

    public static function bootValidatingTrait()
    {
        static::creating(function ($el) {
            if (!$el->isValid()) {
                return false;
            }
        });
        static::updating(function ($el) {
            if (!$el->isValid()) {
                return false;
            }
        });
    }
}
