<?php

namespace Txd\Utils;

final class ClassFinder
{
    private static $composer = null;

    private static $classes = [];

    public function __construct()
    {
        self::$composer = null;
        self::$classes = [];

        self::$composer = require base_path().'/vendor/autoload.php';

        if (empty(self::$composer) === false) {
            self::$classes = array_keys(self::$composer->getClassMap());
        }
    }

    public function getClasses()
    {
        $allClasses = [];

        if (empty(self::$classes) === false) {
            foreach (self::$classes as $class) {
                $allClasses[] = '\\'.$class;
            }
        }

        return $allClasses;
    }

    public function getClassesByNamespace($namespace)
    {
        if (strpos($namespace, '\\') !== 0) {
            $namespace = '\\'.$namespace;
        }

        $termUpper = strtoupper($namespace);

        return array_filter($this->getClasses(), function ($class) use ($termUpper) {
            $className = strtoupper($class);
            if (
                strpos($className, $termUpper) === 0 and
                strpos($className, strtoupper('Abstract')) === false and
                strpos($className, strtoupper('Interface')) === false
            ) {
                return $class;
            }

            return false;
        });
    }

    public function getClassesWithTerm($term)
    {
        $termUpper = strtoupper($term);

        return array_filter($this->getClasses(), function ($class) use ($termUpper) {
            $className = strtoupper($class);
            if (
                strpos($className, $termUpper) !== false and
                strpos($className, strtoupper('Abstract')) === false and
                strpos($className, strtoupper('Interface')) === false
            ) {
                return $class;
            }

            return false;
        });
    }
}
