<?php

namespace Txd\Casts;

use Illuminate\Contracts\Database\Eloquent\CastsInboundAttributes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;
use WeakMap;

class UploadedFileCast implements CastsInboundAttributes
{
    public function __construct(protected string $disk) {}

    /**
     * Ritorna la stringa corretta per settare il cast
     */
    public static function disk(string $disk): string
    {
        return static::class.':'.$disk;
    }

    protected static $processed;

    public function processed(): WeakMap
    {
        if (!static::$processed) {
            static::$processed = new WeakMap;
        }

        return static::$processed;
    }

    /**
     * Prepare the given value for storage.
     *
     * @param  strin|UploadedFile  $name
     * @param  array<string, mixed>  $attributes
     */
    public function set(Model $model, string $key, mixed $value, array $attributes): ?string
    {
        switch (true) {
            case is_string($value):
                return $value;
            case is_a($value, UploadedFile::class):

                if (!$this->processed()->offsetExists($model)) {
                    $disk = $this->disk;
                    $fileName = $value->hashName();
                    $original = $model->getOriginal($key);

                    $savingCallback = function ($savingModel) use ($disk, $model, $value, $key) {
                        if ($model == $savingModel) {
                            $savingModel->$key = Storage::disk($disk)->putFileAs('', $value, $savingModel->$key);
                        }
                    };

                    $savedCallback = function ($savedModel) use ($disk, $model, $original, $key) {
                        if ($model == $savedModel && !is_null($original) && $original !== $savedModel->$key) {
                            if (Storage::disk($disk)->exists($original)) {
                                Storage::disk($disk)->delete($original);
                            }
                        }
                    };

                    $model::class::saving($savingCallback);
                    $model::class::saved($savedCallback);

                    $this->processed()->offsetSet($model, $fileName);
                }

                return $this->processed()->offsetGet($model);
        }

        return null;
    }
}
