<?php

namespace Txd\FieldTypes;

/**
 * Tipo txdAttributes per data
 */
class Date extends Datetime
{
    public function __construct($nome, $etichetta = '', $classi_html = [])
    {
        parent::__construct($nome, $etichetta, $classi_html);
        $this->optFormat(config('par.date_format'));
        $this->htmlProperties()->removeHtmlClass('datatime_picker');
        $this->htmlProperties()->addHtmlClass('data_picker');
    }

    public function parse_valore($valore)
    {
        $data = $valore;
        if (!is_null($valore)) {
            $data = carbonParse($valore);
            $data->isDatetime(false);
        }

        return carbonStampaData($data, $this->parse_options);
    }

    public function tipo_campo_form()
    {
        return 'parse_value';
    }
}
