<?php

use Illuminate\Support\Collection;

if (!function_exists('localUniqueString')) {
    global $localUniqueStringHistory;
    $localUniqueStringHistory = [];
    /**
     * genera una stringa random garantita per la chiamata corrente
     *
     * @return string
     */
    function localUniqueString($prefix = null, $length = 10)
    {
        global $localUniqueStringHistory;
        $string = $prefix.bin2hex(random_bytes($length));
        while (array_key_exists($string, $localUniqueStringHistory)) {
            $string = $prefix.bin2hex(random_bytes($length));
        }
        $localUniqueStringHistory[$string] = null;

        return $string;
    }
}

if (!function_exists('carbonParse')) {
    function carbonParse($time = null, $tz = null)
    {
        if (\Illuminate\Support\Carbon::hasMacro('parseWithDefault')) {
            return \Illuminate\Support\Carbon::parseWithDefault($time, $tz);
        }

        return \Illuminate\Support\Carbon::parse($time, $tz);

    }
}

if (!function_exists('carbonStampaData')) {
    function carbonStampaData($data, $options)
    {
        if (\Illuminate\Support\Carbon::hasMacro('stampa_data')) {
            return \Illuminate\Support\Carbon::stampa_data($data, $options);
        }
        $format = (isset($options['format']) ? $options['format'] : null);
        $escape = (isset($options['escape']) ? $options['escape'] : '');
        if ($format === null) {
            $format = config('par.date_format', 'd/m/Y');
            $format = config('par.datetime_format', $format);
        }

        return $data->format($format);
    }
}

if (!function_exists('optionSelectSearch')) {
    /**
     * @return Closure
     */
    function optionSelectSearch(string $className, string $labelName, string $keyName = 'id', int $limit = 100, ?callable $scope = null)
    {
        return function ($search, $key = '__unset__') use ($className, $labelName, $keyName, $limit, $scope) {
            $query = $className::applicaPermessi();
            $query = optionSelectSearchHelper($query, $search, $key, $labelName, $keyName, $limit);

            if (!is_null($scope)) {
                $query = $scope($query);
            }

            return $query->get()->toArray();
        };
    }
}

if (!function_exists('optionSelectSearchHelper')) {
    function optionSelectSearchHelper($query, $search, $key, string $labelName, string $keyName = 'id', int $limit = 100)
    {
        if ($key !== '__unset__') {
            if (is_array($key)) {
                $query->whereIn($keyName, $key);
            } else {
                $query->where($keyName, $key);
            }
        }
        $query->where($labelName, 'like', "%$search%");
        $query->limit($limit);
        $query->select("$keyName as key", "$labelName as value");

        return $query;
    }
}

if (!function_exists('defaultScopeRicerca')) {
    function defaultScopeRicerca($query, $value, array $fields)
    {
        $value = trim($value ?? '');

        if (strlen($value) > 0) {
            if (is_a($query, Collection::class)) {
                return $query->filter(function ($el) use ($value, $fields) {
                    foreach ($fields as $field) {
                        if (is_string($el->$field)) {
                            if (\Illuminate\Support\Str::contains($el->$field, $value, true)) {
                                return true;
                            }
                        } elseif (is_array($el->$field)) {
                            foreach ($el->$field as $key => $v) {
                                if (\Illuminate\Support\Str::contains($v, $value, true)) {
                                    return true;
                                }
                            }
                        }
                    }

                    return false;
                });
            } else {
                return $query->where(function ($query) use ($value, $fields) {
                    foreach ($fields as $field) {
                        $query->orWhere($field, 'like', '%'.$value.'%');
                    }
                });
            }
        }

        return $query;
    }
}

if (!function_exists('withoutPermissions')) {
    function withoutPermissions($callable)
    {
        $prev = config()->get('txd_fieldtypes.evaluate_permissions_in_relations');
        try {
            config()->set('txd_fieldtypes.evaluate_permissions_in_relations', false);

            return $callable();
        } finally {
            config()->set('txd_fieldtypes.evaluate_permissions_in_relations', $prev);
        }
    }
}