<?php

namespace Txd\Forms;

use Txd\FieldTypes\Enums\TXD_ATTRIBUTES_BUILD_MODE;
use Txd\txdAttributes;

class TxdFilter extends TxdQueryForm {
    public function __construct(\Txd\txdFields $base = null,$defaults = null)
    {
        parent::__construct($base,$defaults ?? $base->current_model_obj());
        $this->skip_verification_field = true;
        
    }

    public $defaultButtons = true;
    public $buttonView ="txd::Forms.Filters.defaultButtons";
   

    public $filterInSession = true;
    public $filterName = null;
    protected function prepareFilterValues(){
        $input  = array_intersect_key(request()->input(),$this->toArray("default"));
        
        if($this->filterInSession){
            $session_key = config("txd_form.session_path").".filters.".($this->filterName??urlencode(request()->url())).".".get_class($this->current_model_obj());
            if(request()->has("reset")) session()->forget($session_key);
            $input=array_merge(session()->get($session_key,[]),$input);
            session()->put($session_key,$input);
        }
        
        $this->current_model_obj()->fill($input);
    }

    public function build(){
        if($this->defaultButtons){
            $this->addStaticHtml("__search"," ")->fillable(false)->custom_build_edit(function($field){
                return view($field->get_current_db_fields()->buttonView)->render();
            });
        }
        $this->transformFields(function(txdAttributes $field){
            $field->set_build_mode(TXD_ATTRIBUTES_BUILD_MODE::EDIT_ONLY);
        });
        $this->loadModelAttributes();
        $this->prepareFilterValues();
        foreach($this as $field){
            $this->query = $field->applyScope($this->query);
        }
        $this->appliedToQuery = true;
        parent::build();
    }

}