<?php

namespace Txd\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class TxdJsonResource extends JsonResource
{
    

    public static $default_fields;
    public $fields;

    public function __construct($resource)
    {
        parent::__construct($resource);
        $this->fields = static::$default_fields;
    }
    
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $this->fields->set_current_model_obj($this);
        $out = $this->fields->getRowProperties();
        $out["raw"] = [];
        foreach($this->fields as $field){
            $view = $field->render_view();
            $out["raw"][$field->nome_campo] = $view;
            $out["fields"][$field->nome_campo] = array_merge(
                    ["content"=>$view],
                    $field->getCellProperties()
                );
        }
        return $out;
    }
}
