<?php

namespace Txd\Forms;

use Txd\Forms\TxdForm;

/**
 * classe di estensione per gestire form legati a query o collection
 */
class TxdQueryForm extends TxdForm {
    
    /**
     * @var mixed querybuider o collection (un array verrà immediatamento convertito in collection)
     */
    public $query;
    protected $appliedToQuery = false;

    /**
     * metodo per finalizzare lo stato dell'istanza e prepararla per la stampa
     * @return void
     */
    public function build(){

    }

    /**
     * assegna la query o collection
     * @param mixed $query
     * 
     * @return void
     */
    public function bind($query){
        if(is_array($query)){
            $query = collect($query);
        }
        $this->query = $query;
        $this->appliedToQuery = false;
    }

}