<?php

namespace Txd\Forms;

use Txd\txdFields;

/**
 * classe per costruire form con i txdFieldTypes
 */
class TxdForm extends txdFields {
    public $defaults = null;

    /**
     * @param txdFields|null $base
     * @param null $defaults
     */
    public function __construct(txdFields $base = null, $defaults = null)
    {
        $this->defaults = $defaults;
        parent::__construct($this->defaults);
        $this->formAttributes["url"] = request()->url();
        if(!is_null($base)){
            foreach($base->toArray() as $key => $sector){
                foreach($sector as $field){
                    $this->addField($field,[$key]);
                }
            }
        }
    }

    /**
     * codice html del form. viene popolato dal metodo ->build()
     * @var string
     */
    public $html = null;
    /**
     * @var string view da usare per il rendering del form
     */
    public $view = null;

    public $formAttributes = [
        
        "method"=>"GET"
    ];
    
    public $htmlAttributes = [
        "class" => "txd-form"
    ];
    
    /**
     * wrapper usato per il form
     * @var string
     */
    public $wrapper = "txd::Forms.Wrappers.FormWrapper";

    public $customViewData = [];
    public $annotateViews = true;

    /**
     * metodo per costuire il codice html del form. il risultato viene salvato nell'attributo ->html
     * @return void
     */
    public function buildHtml(){
        $view = $this->view ?? "txd::Forms.compact";
        $this->html= "";
        if($this->annotateViews){
            $this->html="\r\n<!-- $view -->\r\n";
        }
        
        $this->html .= view($view,array_merge($this->defaultViewData(),["formAttributes"=>$this->formAttributes],$this->customViewData))->render();
    }

    protected function defaultViewData(){
        return ["form"=>$this,"campi"=>$this,"wrapper"=>$this->wrapper];
    }

    public function __toString(){
        if(empty($this->html)){
            $this->buildHtml();
        }
        return $this->html;
    }
}