@php
    $isFirst=!isset($GLOBALS["InlineFormInitialized"]);
    $id=localUniqueString('rangeslider-');
@endphp
@if ($isFirst)
    @php
        $GLOBALS["InlineFormInitialized"]=true;
    @endphp
    @section('custom_css')
        <style>
            .txd-form {
                display: flex;
                justify-content: space-between;
                align-items: flex-start;
                flex-wrap: wrap;
            }
            .txd-form [name="__search"]{
                min-width:220px !important;
            }
            .txd-form > form {
                display: contents;
            }
            .txd-form-sector{
                display: grid;
                grid-template-columns: auto auto;
                align-items:center;
                gap: 0.5rem;
            }
            .txd-form-sector:only-child{
                display: flex;
                justify-content: flex-end;
                flex-wrap: wrap;
                width: 100%;
                column-gap: 1.5rem;
            }
            .txd-form-field-wrapper{
                display: contents;
                column-gap:0.5rem;
            }
            .txd-form-sector:only-child .txd-form-field-wrapper{
                display: flex;
                justify-content: center;
                align-items: center;
            }
            .txd-form-field-wrapper > label{
                margin:0;
                text-align:right;
            }
            /* .txd-form-sector:only-child .txd-form-field-wrapper label{
                margin-right: 0.5rem;
            } */
            .txd-form-field-wrapper > *:only-child{
                grid-column: 1/span 2;
            }
        </style>
    @append
    
@endif


@extends($wrapper)

@section("form")
@php
    
$sectors = $campi->getSectors();
$default = $sectors["default"];
unset($sectors["default"]);
$sectors["default"] = $default;
@endphp

@foreach($sectors as $sector_name => $sector)
@php
$campi_chunks = $campi->toArray($sector_name);
@endphp
    <div class="txd-form-sector {{$sector["class"] ?? ""}}" id="sector_{{$sector_name}}" style="{{$sector["style"] ?? ""}}">

        @foreach($campi_chunks as $campo_obj)
            @if($campo_obj->tipo_campo_form() != "hidden")
            
            <div class="txd-form-field-wrapper {!! $campo_obj->field_visibility_classes()!!} {{ $errors->has($campo_obj->nome_campo) ? 'has-error' : ''}} {!!$campo_obj->classe_box !!}">
                @if(!$campo_obj->skip_label)
                <label for="{{$campo_obj->nome_campo}}" class=" ">
                    {!! $campo_obj->build_label_text() !!}
                @if($campo_obj->is_mandatory())
                    <span class='edit_form_field'> *</span>
                @endif
                </label>
                @endif
                @if($campo_obj->field_build_mode!==2)
                <div class='{!! $campo_obj->field_build_mode ===0?'view_form_field':''!!} vff_style'>
                    {!!$campo_obj->render_view()!!}
                </div>
                @endif
                @if($campo_obj->field_build_mode!==1)
                <div class='{!! $campo_obj->field_build_mode ===0?'edit_form_field':''!!} eff_style'>
                    {!!$campo_obj->render_edit()!!}
                </div>
                @endif

                {!! $errors->first($campo_obj->nome_campo, '<p class="help-block">:message</p>') !!}
            </div>
            @endif

        @endforeach
        @foreach($campi_chunks as $campo_obj)
        @if($campo_obj->tipo_campo_form() == "hidden")
            {!!$campo_obj->render_edit()!!}
        @endif    
        @endforeach

    </div>

@endforeach
@endsection