<?
namespace Txd\Mixins\FieldTypes;

class DateRangeScopeMixin{
    public function scope_start_column(){
        return function(string $name){
            if(count($this->get_query_scope_params())===0){
                $this->replace_query_scope_params([null,null]);
            }
            $this->add_query_scope_params(0,$name);
            return $this;
        };
    }
    public function scope_end_column(){
        return function(string $name){
            if(count($this->get_query_scope_params())===0){
                $this->replace_query_scope_params([null,null]);
            }
            $this->add_query_scope_params(1,$name);
            return $this;
        };
    }

    public function defaultScope(){
        return function($query, $value, ...$scope_params)
        {
            $start_date_column = ($scope_params[0] ?? $this->nome_campo) ?? null;
            $end_date_column = $scope_params[1] ?? $start_date_column;

            if(is_array($value)){
                if(array_key_exists("start",$value)&&!empty($value["start"])){
                    $query->where($end_date_column,">",\classe_data::stampa_data($value["start"], ["format" => "Y-m-d"]));
                }
                if(array_key_exists("end",$value)&&!empty($value["end"])){
                    $query->where($start_date_column,"<",\classe_data::stampa_data($value["end"], ["format" => "Y-m-d"]));
                }
            }
            return $query;
        };
    }        
}