<?php

namespace Txd\Forms;

use Txd\Forms\TxdForm;

/**
 * classe di estensione per gestire form legati a query o collection
 */
class TxdQueryForm extends TxdForm {
    
    /**
     * @var mixed querybuider o collection (un array verrà immediatamento convertito in collection)
     */
    public $query;
    protected $original_query = null;
    protected $final_query = null;
    protected $appliedToQuery = false;

    
    /**
     * assegna la query o collection
     * @param mixed $query
     * 
     * @return void
     */
    public function bind($query){
        if(is_array($query)){
            $query = collect($query);
        }
        $this->original_query = clone $query;
        $this->query = $query;
        $this->appliedToQuery = false;
    }

    /**
     * ritorna una copia della query in ingresso. Può essere un builder o una collection
     * @return mixed
     */
    public function original_query(){
        return clone $this->original_query;
    }

    /**
     * ritorna una copia della query generata. Può essere un builder o una collection. ritorna null se non è stato chiamato il metodo ->build()
     * @return mixed
     */
    public function final_query(){
        return clone $this->final_query;
    }

    protected function store_final_query($query = null){
        $this->final_query = clone ($query ?? $this->query);
    }

}