<?php

namespace Txd\Mixins;

use Opis\Closure\SerializableClosure;

class TxdAttributesScopeMixin {
    public function get_query_scope(){
        return function(){
            return $this->query_scope ?? null;
        };
    }

    public function set_query_scope(){
        return function($scope){
            return $this->query_scope = $scope;
        };
    }
    public function get_query_scope_params(){
        return function(){
            return $this->query_scope_params ?? [];
        };
    }

    public function add_query_scope_params(){
        return function($key,$value){
            $pars = $this->query_scope_params ?? [];
            $pars[$key] = $value;
            $this->query_scope_params = $pars;
        };
    }
    public function replace_query_scope_params(){
        return function($params){
            $this->query_scope_params = $params;
        };
    }
    
    public function scope(){
        return function ($scope,...$scopeArgs)
        {   
            if(is_a($scope,\Closure::class)){
                $scope = new SerializableClosure($scope);
            }
            $this->set_query_scope($scope);
            $this->replace_query_scope_params($scopeArgs);

            return $this;
        };
    }

    /**
     * applica lo scope definito nel campo su $query
     * @param mixed $query
     * 
     * @return mixed
     */
    public function applyScope(){
        return function($query){
            if(is_a($this->get_query_scope(),SerializableClosure::class)){
                $query = ($this->get_query_scope())($query,$this->get_valore(true),...$this->get_query_scope_params());
            }elseif(is_null($this->get_query_scope())){
                $query = $this->defaultScope($query,$this->get_valore(true),...$this->get_query_scope_params());
            }else{
                $scope = "scope".\Illuminate\Support\Str::studly($this->get_query_scope());
                if($scope === "scopeRicerca" && !method_exists($this->current_model_obj,$scope)){
                    $value = $this->get_valore(true);
                    $query_scope_params = $this->get_query_scope_params();
                    $query = $this->defaultScopeRicerca($query,$value,...$query_scope_params);
                }else{
                    $query = call_user_func_array([$this->current_model_obj, $scope], array_merge([$query,$this->get_valore(true)],$this->get_query_scope_params()));
                }
            }
            return $query;
        };
    }

    /**
     * scope di default: equivalente a ->where([nome_campo],$value)
     * @param mixed $query
     * @param mixed $value
     * 
     * @return mixed
     */
    public function defaultScope(){
        return function($query,$value,...$scope_params){
            if(!is_null($value)){
                return $query->where($this->nome_campo,$value);
            }
            return $query;
        };
    }
   
    /**
     * scope di ricerca testuale. $fields deve contenere i nomi delle colonne in cui cercare
     * @param mixed $query
     * @param mixed $value
     * @param array $fields
     * 
     * @return mixed
     */
    public function defaultScopeRicerca(){
        return function($query, $value, array $fields){
            $value = trim($value);
            
            if(strlen($value) > 0){
                $query->where(function($query) use ($value,$fields){
                    foreach($fields as $field){
                        $query->orWhere($field, "like", "%".$value."%");
                    }
                });
            }

            return $query;
        };
    }
}
