@extends($wrapper)

@section("form")
@php
    $campi_no_hidden = array();
	
	if(!isset($colonne)){
		$colonne = 3;
	}
@endphp

@foreach($campi as $campo_obj)
    @if($campo_obj->tipo_campo_form() != "hidden")
        @php
            $campi_no_hidden[$campo_obj->nome_campo] = $campo_obj;
        @endphp
    @endif
@endforeach


@foreach(array_chunk($campi_no_hidden, $colonne) as $campi_chunks)

    <div class="row">

        @foreach($campi_chunks as $campo_obj)


            <div class="col {!! $campo_obj->field_visibility_classes()!!} ">
                <div class="form-group {{ $errors->has($campo_obj->nome_campo) ? 'has-error' : ''}} {!!$campo_obj->classe_box !!}">
                    @if(!$campo_obj->skip_label)
                    <label for="{{$campo_obj->nome_campo}}" class=" ">
						{!! $campo_obj->build_label_text() !!}
					
					@if($campo_obj->is_mandatory())
						<span class='edit_form_field'> *</span>
					@endif
					</label>
                    @endif
					@if($campo_obj->field_build_mode!==2)
					<div class='{!! $campo_obj->field_build_mode ===0?'view_form_field':''!!} vff_style'>
						{!!$campo_obj->render_view()!!}
					</div>
					@endif
					@if($campo_obj->field_build_mode!==1)
					<div class='{!! $campo_obj->field_build_mode ===0?'edit_form_field':''!!} eff_style'>
                        {!!$campo_obj->render_edit()!!}
					</div>
					@endif

					{!! $errors->first($campo_obj->nome_campo, '<p class="help-block">:message</p>') !!}

                </div>
            </div>


        @endforeach

    </div>

@endforeach

@foreach($campi as $campo_obj)

    @if($campo_obj->tipo_campo_form() == "hidden")
        {!!$campo_obj->render_edit()!!}
    @endif
    

@endforeach


@endsection