<?php
namespace Txd\Mixins\FieldTypes;


use DateInterval;
use Illuminate\Support\Collection;

class DateRangeScopeMixin{
    public function scope_start_column(){
        return function(string $name){
            if(count($this->get_query_scope_params())===0){
                $this->replace_query_scope_params([null,null]);
            }
            $this->add_query_scope_params(0,$name);
            return $this;
        };
    }
    public function scope_end_column(){
        return function(string $name){
            if(count($this->get_query_scope_params())===0){
                $this->replace_query_scope_params([null,null]);
            }
            $this->add_query_scope_params(1,$name);
            return $this;
        };
    }

    public function defaultScope(){
        return function($query, $value, ...$scope_params)
        {
            $start_date_column = ($scope_params[0] ?? $this->nome_campo) ?? null;
            $end_date_column = $scope_params[1] ?? $start_date_column;

            if(is_array($value)){
                if(array_key_exists("start",$value)&&!empty($value["start"])){
                    if(is_a($query,Collection::class)){
                        $parsedStart = \Illuminate\Support\Carbon::parse($value["start"]);
                        $query = $query->filter(function($el) use($parsedStart,$end_date_column){
                            return  \Illuminate\Support\Carbon::parse($el->$end_date_column) >= $parsedStart;
                        });
                    }else{
                        $query->where($end_date_column,">=",\Illuminate\Support\Carbon::parse($value["start"])->format("Y-m-d"));
                    }
                }
                if(array_key_exists("end",$value)&&!empty($value["end"])){
                    if(is_a($query,Collection::class)){
                        $parsedEnd = \Illuminate\Support\Carbon::parse($value["end"]);
                        $isDateOnly = !$parsedEnd->is_dataTime();
                        $parsedEnd = $parsedEnd->get_data_object();
                        if($isDateOnly){
                            $parsedEnd->add(new DateInterval('PT23H59M59S'));
                        }
                        
                        $query = $query->filter(function($el) use($parsedEnd,$start_date_column){
                            return \Illuminate\Support\Carbon::parse($el->$start_date_column) < $parsedEnd;
                        });
                    }else{
                        $query->where($start_date_column,"<",\Illuminate\Support\Carbon::parse($value["end"])->format("Y-m-d"));
                    }
                }
            }
            return $query;
        };
    }        
}