<?php

namespace Txd\Forms;

use Txd\FieldTypes\Enums\TXD_ATTRIBUTES_BUILD_MODE;
use Txd\txdAttributes;

class TxdFilter extends TxdQueryForm {
    public function __construct(\Txd\txdFields $base = null,$defaults = null)
    {
        parent::__construct($base,$defaults ?? $base->current_model_obj());
        $this->htmlProperties()->setHtmlClasses(["txd-filter"]);
        $this->view = "txd::Forms.inline";
        $this->skip_verification_field = true;

        $this->addStaticHtml("__search"," ")->custom_build_edit(function($field){
            return view($field->get_current_db_fields()->searchFieldView,["campo_obj"=>$field])->render();
        })->set_placeholder("Cerca...")->set_order(PHP_INT_MAX)->skip_label();
    }

    public $searchFieldView ="txd::Forms.Filters.defaultSearchField";

    public $searchFields = [];
   
    public $filterInSession = true;
    public $filterName = null;
    protected function prepareFilterValues($sectors=[]){
        $input  = array_intersect_key(request()->input(),$this->reduce($sectors)->toArray("default"));
        if($this->filterInSession){
            $session_key = config("txd_form.session_path").".filters.".($this->filterName??urlencode(request()->url())).".".get_class($this->current_model_obj());
            if(request()->has("reset")) session()->forget($session_key);
            $input=array_merge(session()->get($session_key,[]),$input);
            session()->put($session_key,$input);
        }
        $this->current_model_obj()->fill($input);
    }

    public function build($sectors = []){
        if(!is_null($this->retrieve("__search"))){
            $this->retrieve("__search")->scope("ricerca",$this->searchFields);
            $this->sort();
        }
        
        
        $this->transformFields(function(txdAttributes $field){
            $field->set_build_mode(TXD_ATTRIBUTES_BUILD_MODE::EDIT_ONLY);
        },[],true);

        $this->current_model_obj()->set_db_fields($this);
        $this->current_model_obj()->inizializzaCampi();
        $this->prepareFilterValues($sectors);
        
        foreach($this->reduce($sectors) as $field){
            $this->query = $field->applyScope($this->query);
        }
        $this->store_final_query();
        $this->appliedToQuery = true;
    }

}