<?php

namespace Txd\Mixins;

use WeakMap;

class QueryScopeMap {
    protected static ?WeakMap $queryParamsMap = null;
    
    public static function getQueryScope($obj){
        if(is_null(static::$queryParamsMap)) static::$queryParamsMap = new WeakMap();
        return static::$queryParamsMap[$obj]["query_scope"] ?? null;
        
    }
    public static function setQueryScope($obj,$scope){
        if(is_null(static::$queryParamsMap)) static::$queryParamsMap = new WeakMap();
        $orig  = static::$queryParamsMap[$obj] ?? [];
        $orig["query_scope"] = $scope;
        static::$queryParamsMap[$obj] = $orig;
    }
    
    public static function getQueryScopeParams($obj){
        if(is_null(static::$queryParamsMap)) static::$queryParamsMap = new WeakMap();
        return static::$queryParamsMap[$obj]["query_scope_params"] ?? null;
        
    }
    public static function setQueryScopeParams($obj,$params){
        if(is_null(static::$queryParamsMap)) static::$queryParamsMap = new WeakMap();
        $orig  = static::$queryParamsMap[$obj] ?? [];
        $orig["query_scope_params"] = $params;
        static::$queryParamsMap[$obj] = $orig;
    }
}