<?php

namespace Txd\Forms;

use Illuminate\Contracts\View\View;
use Txd\FieldTypes\Enums\TxdAttributeBuildMode;
use Txd\HtmlProperties;
use Txd\txdFields;

/**
 * classe per costruire form con i txdFieldTypes
 */
class TxdForm extends txdFields
{
    /**
     * @var \Txd\traits\txdModel
     */
    public $defaults = null;

    public $id = null;

    /**
     * @param  null  $defaults
     */
    public function __construct(txdFields $base = null, $defaults = null)
    {
        $this->defaults = $defaults;
        parent::__construct($this->defaults);
        $this->htmlProperties()->setHtmlClasses([
            config('txd_forms.default_classes.form_handler'),
            config('txd_forms.default_classes.form_style'),
        ]);
        $this->id = localUniqueString('form_', 5);
        $this->formAttributes['url'] = request()->url();
        $this->formAttributes['id'] = $this->id;
        if (!is_null($base)) {
            foreach ($base->toArray() as $key => $sector) {
                foreach ($sector as $field) {
                    $this->addField($field, [$key]);
                }
            }
            $this->source = $base->source;
        }
    }

    /**
     * @param  mixed  $current_model_obj
     * @param  mixed  $new_item_list
     * @return static
     */
    protected static function init($current_model_obj, $new_item_list)
    {
        $fields = new static(null,$current_model_obj);
        $fields->sectors['default'] = $new_item_list;

        return $fields;
    }

    /**
     * codice html del form. viene popolato dal metodo ->build()
     *
     * @var string
     */
    public $html = null;

    /**
     * @var string view da usare per il rendering del form
     */
    public $view = null;

    public $formAttributes = [

        'method' => 'GET',
        'files' => true,
    ];

    protected ?HtmlProperties $htmlProperties = null;

    public function htmlProperties(): HtmlProperties
    {
        if (!isset($this->htmlProperties)) {
            $this->htmlProperties = new HtmlProperties();
        }

        return $this->htmlProperties;
    }

    /**
     * wrapper usato per il form
     *
     * @var string
     */
    public $wrapper = 'txd::Forms.Wrappers.FormWrapper';

    public $customViewData = [];

    public $annotateViews = true;

    /**
     * metodo per costuire il codice html del form. il risultato viene salvato nell'attributo ->html
     *
     * @return void
     */
    public function buildHtml()
    {
        $view = $this->view ?? 'txd::Forms.compact';
        $this->html = '';
        if ($this->annotateViews) {
            $this->html = "\r\n<!-- $view -->\r\n";
        }

        $this->html .= $this->getView()->render();
    }

    public function getView(): View
    {
        $view = $this->view ?? 'txd::Forms.compact';

        return view($view, array_merge($this->defaultViewData(), ['formAttributes' => $this->formAttributes], $this->customViewData));
    }

    protected function defaultViewData()
    {
        return ['form' => $this, 'campi' => $this, 'wrapper' => $this->wrapper];
    }

    public function __toString()
    {
        if (empty($this->html)) {
            $this->buildHtml();
        }

        return $this->html;
    }

    public function set_build_mode(TxdAttributeBuildMode|int $txd_attribute_build_mode_flag = 0)
    {
        $this->transformFields(fn ($field) => $field->set_build_mode($txd_attribute_build_mode_flag));
    }
}
