<?php

namespace Txd\Mixins\FieldTypes;

class SelectScopeMixin
{
    public function defaultScope()
    {
        return function ($query, $value, ...$scope_params) {
            if ($this->is_multiple()) {
                if (!empty($value)) {
                    return $query->whereIn($this->nome_campo, $value);
                }
            } else {
                return $this->call_extension_as(parent::class)->defaultScope($query, $value, ...$scope_params);
            }

            return $query;
        };
    }
}
