<?php

namespace Txd\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class TxdJsonResource extends JsonResource
{
    public static $default_fields = null;

    public $fields;

    protected $originalResource = null;

    public function __construct($resource)
    {
        parent::__construct($resource);
        $this->originalResource = $resource;
        $this->fields = static::$default_fields;
    }

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $this->fields->set_current_model_obj($this->originalResource);
        $out = [];
        $this->fields->rowProperties()->setRenderArguments($this->originalResource);
        $out['classes'] = $this->fields->rowProperties()->renderClasses();
        $out['style'] = $this->fields->rowProperties()->renderStyle();
        $out['attributes'] = $this->fields->rowProperties()->renderAttributes();
        $out['raw'] = $this->originalResource;
        foreach ($this->fields as $field) {
            $view = $field->render_view();
            $field->cellProperties()->setRenderArguments($this->originalResource);
            $out['fields'][$field->nome_campo] = [
                'content' => $view,
                'classes' => $field->cellProperties()->renderClasses(),
                'style' => $field->cellProperties()->renderStyle(),
                'attributes' => $field->cellProperties()->renderAttributes(),
            ];
        }

        return $out;
    }

    public static function scopedFieldObject($field, $callback)
    {
        static::$default_fields = $field;
        $next = $callback();
        static::$default_fields = null;

        return $next;
    }
}
