@extends($wrapper)

@section("form")
@foreach($form->columns ?? ["default"] as $settori)
    <div class="txd-form-sector">
        @php
            $campi_settore = $form->reduce($settori);
            $campi_visibili = array();
            $campi_hidden = array();
            foreach($campi_settore as $campo_obj){
                if($campo_obj->tipo_campo_form() != "hidden"){
                    $campi_visibili[$campo_obj->nome_campo] = $campo_obj;
                }else{
                    $campi_hidden[$campo_obj->nome_campo] = $campo_obj;
                }
            }
        @endphp

        @foreach($campi_visibili as $campo_obj)
            <div class="txd-form-row {!! $campo_obj->field_visibility_classes()!!} {!!$campo_obj->classe_box !!}" data-field="{{$campo_obj->build_nome_input()}}" data-error="{{$campo_obj->has_errors()}}">
                
                    @if(!$campo_obj->skip_label)
                    <label for="{{$campo_obj->nome_campo}}" class=" ">
                        {!! $campo_obj->build_label_text() !!}
                    
                    @if($campo_obj->is_mandatory())
                        <span class='edit_form_field'> *</span>
                    @endif
                    </label>
                    @endif
                    @if($campo_obj->field_build_mode!==2)
                    <div class='{!!$campo_obj->skip_label?"full-column":""!!} {!! $campo_obj->field_build_mode ===0?'view_form_field':''!!} vff_style'>
                        {!!$campo_obj->render_view()!!}
                    </div>
                    @endif
                    @if($campo_obj->field_build_mode!==1)
                    <div class='{!!$campo_obj->skip_label?"full-column":""!!} {!! $campo_obj->field_build_mode ===0?'edit_form_field':''!!} eff_style'>
                        {!!$campo_obj->render_edit()!!}
                        {!!$campo_obj->render_errors()!!}
                    </div>
                    @endif

                
            </div>
        @endforeach

        @foreach($campi_hidden as $campo_obj)
                {!!$campo_obj->render_edit()!!}
        @endforeach
</div>
@endforeach


@endsection