<?php

namespace Txd\Forms;

use Txd\HtmlProperties;

class FormProperties extends HtmlProperties
{
    

    public function getUrl()
    {
        return $this->getHtmlAttributes()['action'] ?? null;
    }

    public function setUrl(string $url)
    {
        $this->addHtmlAttribute('action', $url);

        return $this;
    }

    public function supportsFiles(bool $enable = true)
    {
        if ($enable) {
            $this->addHtmlAttribute('enctype', 'multipart/form-data');
        } else {
            $this->removeHtmlAttribute('enctype');
        }

        return $this;
    }
}
