<?php

namespace Txd\Forms;

use Illuminate\Contracts\View\View;
use Txd\FieldTypes\Enums\TxdAttributeBuildMode;
use Txd\HtmlProperties;
use Txd\txdFields;

/**
 * classe per costruire form con i txdFieldTypes
 */
class TxdForm extends txdFields
{
    /**
     * @var \Txd\traits\txdModel
     */
    public $defaults = null;

    /**
     * Use ->id() instead
     *
     * @deprecated
     *
     * @var mixed
     */
    public $id = null;

    /**
     * @param  null  $defaults
     */
    public function __construct(txdFields $base = null, $defaults = null)
    {
        $this->defaults = $defaults;
        parent::__construct($this->defaults);
        $this->formProperties()
            ->addHtmlAttribute('accept-charset', 'UTF-8')
            ->supportsFiles();
        $this->htmlProperties()->setHtmlClasses([
            config('txd_forms.default_classes.form_handler'),
            config('txd_forms.default_classes.form_style'),
        ]);

        $this->formProperties()->setUrl(request()->url());
        $this->formProperties()->setHtmlId(localUniqueString('form_', 5));
        $this->id = $this->formProperties()->getHtmlId();
        if (!is_null($base)) {
            foreach ($base->toArray() as $key => $sector) {
                foreach ($sector as $field) {
                    $this->addField($field, [$key]);
                }
            }
            $this->source = $base->source;
        }
    }

    /**
     * @param  mixed  $current_model_obj
     * @param  mixed  $new_item_list
     * @return static
     */
    protected static function init($current_model_obj, $new_item_list)
    {
        $fields = new static(null,$current_model_obj);
        $fields->sectors['default'] = $new_item_list;

        return $fields;
    }

    /**
     * codice html del form. viene popolato dal metodo ->build()
     *
     * @var string
     */
    public $html = null;

    /**
     * @var string view da usare per il rendering del form
     */
    public $view = null;

    /**
     * Use ->formProperties() instead
     *
     * @deprecated
     *
     * @var array
     */
    public $formAttributes = [
        
    ];

    protected ?FormProperties $formProperties = null;

    /**
     * Helper per la gestione degli attributi html del tag form
     */
    public function formProperties(): FormProperties
    {
        if (!isset($this->formProperties)) {
            $this->formProperties = new FormProperties();
        }

        return $this->formProperties;
    }

    protected ?HtmlProperties $htmlProperties = null;

    /**
     * Helper per la gestione degli attributi html del wrapper html al tag form
     *
     * @return FormProperties
     */
    public function htmlProperties(): HtmlProperties
    {
        if (!isset($this->htmlProperties)) {
            $this->htmlProperties = new HtmlProperties();
        }

        return $this->htmlProperties;
    }

    public function id()
    {
        return $this->formProperties()->getHtmlId();
    }

    protected string $method = "GET";
    public function getMethod()
    {
        return $this->method;
    }

    /**
     * Sets the method of the form. The method string will be stored in uppercase
     *
     * @param string $method
     * @return $this
     */
    public function setMethod(string $method)
    {
        $this->method = strtoupper($method);

        return $this;
    }
    
    /**
     * Sets the action url of the form
     *
     * @param string|callable $url
     * @return $this
     */
    public function setUrl($url)
    {
        $this->formProperties()->setUrl($url);
        return $this;
    }
    /**
     * wrapper usato per il form
     *
     * @var string
     */
    public $wrapper = 'txd::Forms.Wrappers.FormWrapper';

    public $customViewData = [];

    public $annotateViews = true;

    /**
     * metodo per costuire il codice html del form. il risultato viene salvato nell'attributo ->html
     *
     * @return void
     */
    public function buildHtml()
    {
        $view = $this->view ?? 'txd::Forms.compact';
        $this->html = '';
        if ($this->annotateViews) {
            $this->html = "\r\n<!-- $view -->\r\n";
        }

        $this->html .= $this->getView()->render();
    }

    public function getView(): View
    {
        $view = $this->view ?? 'txd::Forms.compact';

        if(isset($this->formAttributes["files"])){
            $this->formProperties()->supportsFiles($this->formAttributes["files"]);
        }

        if(isset($this->formAttributes["url"])){
            $this->formProperties()->setUrl($this->formAttributes["url"]);
        }
        
        foreach($this->formAttributes as $key => $value){
            switch($key){
                case "files":
                    $this->formProperties()->supportsFiles($value);
                    break;
                case "url":
                    $this->formProperties()->setUrl($value);
                    break;
                case "class":
                    $this->formProperties()->addHtmlClass($value);
                    break;
                case "method":
                    $this->setMethod($value);
                    break;
                case "style":
                    \Log::warn("WARNING: the use of 'style' in \$formAttributes is deprecated. use ->formProperties() instead (or even better, use css classes)",["form"=>json_decode(json_encode($this))]);
                    break;
                default:
                    $this->formProperties()->addHtmlAttribute($key,$value);
                    break;
            }
        }
        
        $this->formProperties()->addHtmlAttribute("method",$this->getMethod() === "GET" ? "GET":"POST");
        
        
        
        return view($view, array_merge($this->defaultViewData(), $this->customViewData));
    }

    protected function defaultViewData()
    {
        return ['form' => $this, 'campi' => $this, 'wrapper' => $this->wrapper];
    }

    public function __toString()
    {
        if (empty($this->html)) {
            $this->buildHtml();
        }

        return $this->html;
    }

    public function set_build_mode(TxdAttributeBuildMode|int $txd_attribute_build_mode_flag = 0)
    {
        $this->transformFields(fn ($field) => $field->set_build_mode($txd_attribute_build_mode_flag));
    }
}
