<?php

namespace Txd\Forms;

use Illuminate\Support\Collection;
use Txd\FieldTypes\Enums\TXD_ATTRIBUTES_BUILD_MODE;
use Txd\FieldTypes\GroupControl;
use Txd\HtmlProperties;
use Txd\Http\Resources\TxdJsonResource;
use Txd\txdAttributes;

class TxdGrid extends TxdQueryForm
{
    /**
     * @var \Illuminate\Http\Resources\Json\AnonymousResourceCollection
     */
    public $resource;

    public function __construct(\Txd\txdFields $base = null, $defaults = null)
    {
        parent::__construct($base, $defaults ?? $base->current_model_obj());
        $this->sortableFields = collect();
        $this->htmlProperties()->setHtmlClasses([
            config('txd_forms.default_classes.grid_handler'),
            config('txd_forms.default_classes.grid_style'),
        ]);

        $this->transformFields(function (txdAttributes $field) {
            $field->set_build_mode(TXD_ATTRIBUTES_BUILD_MODE::VIEW_ONLY);
        });

        $this->view = 'txd::Forms.Grids.default';
    }

    /**
     * usare metodo useGrouping
     *
     * @internal
     *
     * @deprecated
     *
     * @var array
     */
    public $groupByFields = [];

    /**
     * usare metodo setAggregateFields
     *
     * @deprecated
     *
     * @internal
     *
     * @var array<string,string|callable>
     */
    public $aggregateFields = [];

    /**
     * usare metodo useGrouping
     *
     * @internal
     *
     * @deprecated
     *
     * @var string
     */
    public $groupBy = null;

    /**
     * usare metodo useGrouping
     *
     * @internal
     *
     * @deprecated
     *
     * @var string
     */
    public $groupByName = 'group_by';

    public $is_grouped = false;

    protected $group_control = true;

    public $groupControlClass = GroupControl::class;

    public $paginationInSession = true;

    public $sessionName = null;

    protected function getCurrentPage()
    {
        $maxPage = 1;
        if ($this->perPage > 0) {
            $maxPage = ceil($this->query->count() / $this->perPage);
        }

        if (!$this->paginationInSession) {
            return min($maxPage, $this->page ?? request()->input($this->pageName, null));
        }

        $session_key = config('txd_forms.session_path').'.pagination.'.($this->sessionName ?? urlencode(request()->url())).'.'.$this->pageName;
        if (request()->has('reset')) {
            session()->forget($session_key);
        }
        $p = null;
        if (!is_null($this->page)) {
            $p = min($maxPage, $this->page);
        } elseif (request()->has($this->pageName)) {
            $p = min($maxPage, request()->input($this->pageName, null));
        } else {
            $p = min($maxPage, session()->get($session_key, null));
        }
        if (!is_null($p)) {
            session()->put($session_key, $p);
        }

        return session()->get($session_key, null);
    }

    public $groupingInSession = true;

    protected function getCurrentGrouping()
    {
        if (!$this->groupingInSession) {
            return request()->input($this->groupByName, $this->groupBy);
        }

        $session_key = config('txd_forms.session_path').'.grouping.'.($this->sessionName ?? urlencode(request()->url())).'.'.$this->groupByName;
        if (request()->has('reset')) {
            session()->forget($session_key);
        }
        $group = null;
        if (!is_null($this->groupBy)) {
            $group = $this->groupBy;
        } elseif (request()->has($this->groupByName)) {
            $group = request()->input($this->groupByName, null);
        } else {
            $group = session()->get($session_key, null);
        }
        if (!in_array($group, $this->groupByFields)) {
            $group = null;
        }
        session()->put($session_key, $group);

        return session()->get($session_key, null);
    }

    protected $groupHeaderBuilder = null;

    public function setGroupHeaderBuilder($handler)
    {
        $this->groupHeaderBuilder = $handler;
    }

    /**
     * abilita il raggruppamento della tabella
     *
     * @param  string  $default
     * @param  array  $otherColumns
     * @return void
     */
    public function useGrouping($default, $otherColumns = [], $groupByName = 'group_by')
    {
        $this->groupBy = $default;
        $this->groupByFields = array_filter(array_merge([$default], $otherColumns));
        $this->groupByName = $groupByName;
    }

    /**
     * definisce i metodi per costruire gli oggetti aggregati
     *
     * @param  array<string,string|callable>  $fields
     * @return void
     */
    public function setAggregateFields($fields)
    {
        $this->aggregateFields = $fields;
    }

    /**
     * Definisce se utilizzare il raggruppamento automatico (basato su collapse di bootstrap). usato solo per grid raggruppate
     *
     * @return void
     */
    public function useGroupControl(bool $enable = true)
    {
        $this->group_control = $enable;
    }

    protected $row_index = 0;

    public $viewTotalRows = 'txd::Forms.Grids.defaultTotalRows';

    public $viewRow = 'txd::Forms.Grids.defaultRow';

    public $viewHeader = 'txd::Forms.Grids.defaultHeader';

    public $viewPagination = 'txd::Forms.Grids.defaultPagination';

    protected function defaultViewData()
    {
        return [
            'grid' => $this,
            'TotalRowsView' => $this->viewTotalRows,
            'RowView' => $this->viewRow,
            'HeaderView' => $this->viewHeader,
            'PaginationView' => $this->viewPagination,
        ];
    }

    public $orderBy = [];

    protected function sortQuery()
    {
        $this->prepareOrderByValues();
        if (is_a($this->query, Collection::class) && count($this->orderBy) > 0) {
            // implementazione valida da Laravel 8 in poi
            // $this->query = $this->query->sortBy($this->orderBy);
            // fallback per laravel 6, solo il primo livello di sort viene applicato in quanto i metodi sort di php non sono consistenti
            [$key,$direction] = $this->orderBy[0];
            $this->query = $this->query->sortBy($key, SORT_REGULAR, strtolower($direction) === 'desc');
        } else {
            foreach ($this->orderBy as $field) {
                [$columnLabel,$direction] = $field;
                $column = $this->sortableFields[$columnLabel] ?? null;
                if (!is_null($column)) {
                    if($column === "default"){
                        $this->query = $this->query->orderBy($columnLabel, $direction ?? 'asc');
                    }else if(is_callable($column)){
                        $this->query = $column($this->query, $direction?? 'asc');
                    }
                }
            }
        }

        return $this->query;
    }

    public $perPage = PHP_INT_MAX;

    public $page = null;

    public $pageName = 'page';

    public function paginate($perPage = 20, $pageName = 'page')
    {
        $this->perPage = $perPage;
        $this->pageName = $pageName;

        return $this;
    }

    public function build()
    {
        $this->query = $this->sortQuery($this->query);
        if (is_null($this->perPage)) {
            $this->perPage = $this->query->count();
        }
        $this->store_final_query();

        $grouping = $this->getCurrentGrouping();

        if (!is_null($grouping)) {
            $this->is_grouped = true;
            if (!is_a($this->query, Collection::class)) {
                $this->query = $this->query->get();
            }
            $this->query = $this->query->groupBy($grouping)->sortKeys();
        }

        $this->query = $this->query->paginate($this->perPage, ['*'], $this->pageName, $this->getCurrentPage());

        $this->appliedToQuery = true;
        $this->row_index = 0;
        if ($this->is_grouped) {
            if ($this->group_control) {
                $this->add('group_control', $this->groupControlClass, ' ')->before(array_keys($this->toArray('default'))[0] ?? 'missing');
            }

            $this->resource = $this->query->map(function ($coll, $key) use ($grouping) {
                $aggregate = [];
                if (is_a($this->original_query(), Collection::class)) {
                    $model = get_class($this->original_query()->first());
                } else {
                    $model = $this->original_query()->getModel();
                }
                $item = new $model;
                $item->group_control = $grouping;
                $item->$grouping = $key;

                foreach ($this->aggregateFields as $field => $method) {
                    if (is_string($method)) {
                        $item->$field = $coll->$method($field);
                    } else {
                        $item->$field = $coll->reduce($method);
                    }
                }
                $aggregate['item'] = TxdJsonResource::scopedFieldObject($this, function () use ($item) {
                    return new TxdJsonResource($item);
                });
                if ($this->groupHeaderBuilder) {
                    $aggregate['row'] = ($this->groupHeaderBuilder)($item, $coll);
                }
                $aggregate['group'] = TxdJsonResource::scopedFieldObject($this, function () use ($coll) {
                    return TxdJsonResource::collection($coll);
                });

                return $aggregate;
            });
        } else {
            $this->resource = TxdJsonResource::scopedFieldObject($this, function () {
                return TxdJsonResource::collection($this->query);
            });
        }
    }

    public function printPagination()
    {
        return $this->query->toHtml();
    }

    public function totalRows()
    {
        return $this->query->total();
    }

    protected ?HtmlProperties $rowProperties = null;

    public function rowProperties(): HtmlProperties
    {
        if (!isset($this->rowProperties)) {
            $this->rowProperties = new HtmlProperties($this);
        }

        return $this->rowProperties;
    }

    protected ?HtmlProperties $headerProperties = null;

    public function headerProperties(): HtmlProperties
    {
        if (!isset($this->headerProperties)) {
            $this->headerProperties = new HtmlProperties($this);
        }

        return $this->headerProperties;
    }

    protected array $headerCellProperties = [];

    public function headerCellProperties(string $columnName): HtmlProperties
    {
        if (!array_key_exists($columnName, $this->headerCellProperties)) {
            $this->headerCellProperties[$columnName] = new HtmlProperties($this);
        }

        return $this->headerCellProperties[$columnName];
    }

    protected $sortableFields = null;

    /**
     * assegna le colonne su cui è possibile ordinare la grid
     *
     * @param  array  $fields
     * @return $this
     */
    public function sortables($fields = null)
    {
        if (is_null($fields)) {
            return $this->sortableFields->toArray();
        }

        $gridColumns = $this->toArray('default');
        $this->sortableFields = collect($fields ?? [])->map(function($item,$key){
            if(is_integer($key)){
                $key = $item;
                $item = "default";
            }
            return ["item" => $item,"key" => $key];
        })->filter(fn($el)=>$el["item"]!="default"||array_key_exists($el["key"],$gridColumns))->keyBy("key")->map(fn($el) => $el["item"]);
        
        return $this;
    }

    public $orderName = 'order';

    protected function prepareOrderByValues()
    {
        $direction = 'asc';
        if (request()->has($this->orderName.'Desc')) {
            $direction = 'desc';
        }
        $field = request()->input($this->orderName.'Asc', request()->input($this->orderName.'Desc', null));

        if (!is_null($field) && array_key_exists($field, $this->sortables())) {
            $this->orderBy = array_merge([[$field, $direction]], $this->orderBy);
        } else {
            $field = null;
        }

        if ($this->paginationInSession) {
            $session_key = config('txd_forms.session_path').'.pagination.'.($this->sessionName ?? urlencode(request()->url())).'.orderBy';
            if (request()->has('reset')) {
                session()->forget($session_key);
            }
            $sessionvalues = session()->get($session_key, []);
            $filteredSessionValues = array_filter($sessionvalues, function ($el) use ($field) {
                return $el[0] !== $field;
            });
            $this->orderBy = array_merge($this->orderBy, $filteredSessionValues);
            $this->orderBy = collect($this->orderBy)->groupBy(0)->map(fn($el)=>$el[0])->values()->toArray();
            session()->put($session_key, $this->orderBy);
        }
    }
}
