<?php

namespace Txd\Forms;

use Txd\FieldTypes\Enums\TXD_ATTRIBUTES_BUILD_MODE;
use Txd\txdAttributes;

class TxdFilter extends TxdQueryForm
{
    public $searchFieldView = 'txd::Forms.Filters.defaultSearchField';

    public $searchFields = [];

    public $filterInSession = true;

    public $filterName = null;

    public function __construct(\Txd\txdFields $base = null, $defaults = null)
    {
        parent::__construct($base, $defaults ?? $base->current_model_obj());
        $this->htmlProperties()->setHtmlClasses(['txd-filter']);
        $this->view = 'txd::Forms.inline';
        $this->skip_verification_field = true;

        $this->addStaticHtml('__search', ' ')->custom_build_edit(function ($field) {
            return view($field->get_current_db_fields()->searchFieldView, ['campo_obj' => $field,'_searchButtonsOnly' =>$this->_searchButtonsOnly])->render();
        })->set_order(PHP_INT_MAX)->skip_label()->htmlProperties()->addHtmlAttribute("placeholder",'Cerca...');
    }

    protected function prepareFilterValues($sectors = [])
    {
        $input = array_intersect_key(request()->input(), $this->reduce($sectors)->toArray('default'));
        if ($this->filterInSession) {
            $filterName = $this->filterName ?? $this->getDefaultFilterName();

            if (request()->has('reset')) {
                static::clearSessionSource($filterName);
            }
            $input = static::mergeSessionSource($filterName, $input);
        }
        foreach($input as $key => $value){
            $this->current_model_obj()->{$key} = $value;    
        }
    }

    public function build($sectors = [])
    {
        if (!is_null($this->retrieve('__search'))) {
            $this->retrieve('__search')->scope('ricerca', $this->searchFields);
            $this->sort();
        }

        $this->transformFields(function (txdAttributes $field) {
            $field->set_build_mode(TXD_ATTRIBUTES_BUILD_MODE::EDIT_ONLY);
        }, [], true);

        $this->current_model_obj()->set_db_fields($this);
        
        $this->prepareFilterValues($sectors);

        foreach ($this->reduce($sectors) as $field) {
            $this->query = $field->applyScope($this->query);
        }
        $this->store_final_query();
        $this->appliedToQuery = true;
    }

    public function getDefaultFilterName()
    {
        $obj = $this->current_model_obj();

        return urlencode(request()->url()).'.'.$obj::class;
    }

    public static function getSessionSource(string $filterName): array
    {
        $session_key = config('txd_form.session_path').'.filters.'.$filterName;

        return session()->get($session_key, []);
    }

    public static function setSessionSource(string $filterName, array $payload): void
    {
        $session_key = config('txd_form.session_path').'.filters.'.$filterName;
        session()->put($session_key, $payload);
    }

    public static function clearSessionSource(string $filterName): void
    {
        $session_key = config('txd_form.session_path').'.filters.'.$filterName;
        session()->forget($session_key);
    }

    public static function mergeSessionSource(string $filterName, array $payload): array
    {
        $current = static::getSessionSource($filterName);
        $payload = array_merge($current, $payload);
        static::setSessionSource($filterName, $payload);

        return $payload;
    }
    
    protected $_searchButtonsOnly = false;
    
    public function searchButtonsOnly(bool $enable = true){
        $this->_searchButtonsOnly = $enable;
        return $this;
    }
}
