<?php

namespace Txd\Provider;

use Illuminate\Support\ServiceProvider;

/**
 *  *
 * @author Fabio Spadea <fabio@techseed.it>
 */
class FormsServiceProvider extends ServiceProvider
{
    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {
        $this->publishes([
            __DIR__.'/../config/txd_forms.php' => config_path('txd_forms.php'),
        ], 'txd_forms:config');

        $this->publishes([
            __DIR__.'/../views/Forms' => base_path('resources/views/vendor/txd/Forms'),
        ], 'txd_forms:views');

        $this->mergeConfigFrom(
            __DIR__.'/../config/txd_forms.php', 'txd_forms'
        );

        //caricamento namespace per view
        $this->loadViewsFrom(base_path('resources/views/vendor/txd'), 'txd');
        $this->loadViewsFrom(__DIR__.'/../views', 'txd');

        if (!\Illuminate\Database\Eloquent\Collection::hasMacro('paginate')) {
            \Illuminate\Database\Eloquent\Collection::macro('paginate',
                function ($perPage = 15, $columns = ['*'], $pagename = 'page', $page = null) {
                    $page = $page ?: (\Illuminate\Pagination\Paginator::resolveCurrentPage($pagename) ?: 1);

                    return (new \Illuminate\Pagination\LengthAwarePaginator(
                        $this->forPage($page, $perPage), $this->count(), $perPage, $page, ['pageName' => $pagename]))
                        ->withPath('');
                });
        }
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register() {}
}
