<?php

namespace Txd\JobsMonitor\Commands;

use DB;
use Illuminate\Console\Command;

class JobsQueueClearStatsCommand extends Command
{
    protected $signature = 'txd:jobs-monitor-clear-stats {--type= : Type of stats to clear (all, notifications, entries)}';

    protected $description = 'Clear jobs queue stats';

    protected $current_default_db_connection;

    public function __construct()
    {
        parent::__construct();

        $this->current_default_db_connection = config('database.default');
    }

    /**
     * @return \Illuminate\Console\View\Components\Factory|self
     */
    protected function console_write()
    {
        if (property_exists($this, 'components') && is_a($this->{'components'}, 'Illuminate\Console\View\Components\Factory')) {
            /** @var \Illuminate\Console\View\Components\Factory $callable_message_component */
            $callable_message_component = $this->{'components'};
        } else {
            /** @var self $callable_message_component */
            $callable_message_component = $this;
        }

        return $callable_message_component;
    }

    public function handle()
    {
        if (! config('txd_jobs_monitor.enabled')) {
            $this->console_write()->info('Jobs monitor is disabled');

            return;
        }

        $type = $this->option('type');

        $clear_all = false;
        $clear_notifications = false;
        $clear_entries = false;

        switch ($type) {
            case 'all':
                $clear_all = true;
                break;
            case 'notifications':
                $clear_notifications = true;
                break;
            case 'entries':
                $clear_entries = true;
                break;
            default:
                $this->console_write()->error('Invalid type of stats to clear');
        }

        // Config values
        $sqliteDbPath = config('txd_jobs_monitor.sqlite_db_path');

        // Set up the SQLite connection using the configured path
        config(['database.connections.custom_sqlite' => [
            'driver' => 'sqlite',
            'database' => $sqliteDbPath,
            'prefix' => '',
        ]]);

        // Temporarily use the custom SQLite connection
        DB::setDefaultConnection('custom_sqlite');

        initJobsMonitorStatsDB();

        if ($clear_all) {
            $this->console_write()->warn('Recreating stats database');
            initJobsMonitorStatsDB($clear_all);
        }

        if ($clear_notifications) {
            $this->console_write()->warn('Deleting notifications');
            DB::table('notifications')->truncate();
        }

        if ($clear_entries) {
            $this->console_write()->warn('Deleting entries');
            DB::table('queue_job_status')->truncate();
        }

        DB::setDefaultConnection($this->current_default_db_connection);
    }
}
