<?php

namespace Txd\JobsMonitor\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class NotificationMail extends Mailable
{
    use Queueable, SerializesModels;

    protected $oggetto;

    protected $testo;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($oggetto = null, $testo = null)
    {
        $this->oggetto = $oggetto ?? 'Email subject';
        $this->testo = $testo ?? '<p>Content of the e-mail!</p>';
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject($this->oggetto)
            ->view('txd::jobsMonitor.notification_mail', ['subject' => $this->oggetto, 'messaggio_plain' => $this->testo]);
    }
}
