<?php

if (! function_exists('initJobsMonitorStatsDB')) {

    /**
     * Initialize the SQLite database if not already created.
     */
    function initJobsMonitorStatsDB($fresh = false)
    {

        if ($fresh) {
            if (file_exists(config('txd_jobs_monitor.sqlite_db_path'))) {
                unlink(config('txd_jobs_monitor.sqlite_db_path'));
            }
        }

        if (! file_exists(config('txd_jobs_monitor.sqlite_db_path'))) {
            touch(config('txd_jobs_monitor.sqlite_db_path'));
        }

        if (! DB::getSchemaBuilder()->hasTable('queue_job_status')) {
            DB::getSchemaBuilder()->create('queue_job_status', function ($table) {
                $table->unsignedInteger('id')->autoIncrement();
                $table->string('queue_name');
                $table->integer('job_count');
                $table->timestamp('created_at');
            });
        }

        if (! DB::getSchemaBuilder()->hasTable('notifications')) {
            DB::getSchemaBuilder()->create('notifications', function ($table) {
                $table->string('action')->primary();
                $table->boolean('executed');
            });
        }
    }
}
