<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Enabled
    |--------------------------------------------------------------------------
    |
    | determina se il componente e' attivo o meno
    |
    */
    'enabled' => env('TXD_JOBS_MONITOR_ENABLED', false),

    'time_range_min' => 5, // minutes
    'max_jobs_queue_len' => 10,
    'max_jobs_per_queue' => null,

    'sqlite_db_path' => storage_path('app/jobs_monitor.db'),

    'active_notification' => [
        'email' => true,
        'webhook' => false,
    ],

    'notifications' => [
        'email' => [
            'recipients' => env('TXD_JOBS_MONITOR_RECIPIENTS'), // comma separated list of email addresses
        ],
        'webhook' => [
            'url' => env('TXD_JOBS_MONITOR_WEBHOOK_URL'),
            'method' => 'POST',
            'headers' => [
                'Content-Type' => 'application/json',
            ],
        ],
    ],

];
