# txdJobsMonitor Package

This package provides a command to monitor the jobs queue in a Laravel application and notify when certain conditions are met. It supports monitoring job counts in different queues and triggers alerts when thresholds are exceeded.

### Installation

1.  Install the package via Composer:
    ```bash
    composer require txd/jobs-monitor
    ```

2.  Publish the configuration file:
    ```bash
    php artisan vendor:publish --provider="Txd\JobsMonitor\JobsMonitorServiceProvider"
    ```

3.  Configure the package by editing the `config/txd_jobs_monitor.php` file.

4.  Add a scheduled command into `app/Console/Kernel.php`

    ```php
    $schedule->command('txd:jobs-monitor')
        ->everyMinute()
        ->withoutOverlapping();
    ```

### Configuration

The configuration file allows you to set various parameters for monitoring the jobs queue:

- `enabled`: Enable or disable the jobs monitor.
- `time_range_min`: The time range in minutes to consider for job counts.
- `max_jobs_per_queue`: The maximum allowed jobs per queue.
- `max_jobs_queue_len`: The maximum allowed total jobs count.
- `sqlite_db_path`: The path to the SQLite database file used for storing job statuses.
- `active_notification`: An array of notification channels to use when alerts are triggered.

### Usage

To start monitoring the jobs queue, run the following Artisan command:

    php artisan txd:jobs-monitor

### Tests

    composer install && \
        composer test

### TODO

- multichannel notification (actually only E-mail works)
- diffent limit per queue

### License

This package is open-source software licensed under the MIT license.