# txdJobsMonitor Package

This package provides a command to monitor the jobs queue in a Laravel application and notify when certain conditions are met. It supports monitoring job counts in different queues and triggers alerts when thresholds are exceeded.

### Installation

1.  Install the package via Composer:
    ```bash
    composer require txd/jobs-monitor
    ```

2.  Publish the configuration file:
    ```bash
    php artisan vendor:publish --tag="txd_jobsMonitor:config"
    ```

3.  Configure the package by editing the `config/txd_jobs_monitor.php` file.

4.  Add a scheduled command into `app/Console/Kernel.php`

    ```php
    $schedule->command('txd:jobs-monitor')
        ->everyMinute()
        ->withoutOverlapping();
    ```

### Configuration

The configuration file allows you to set various parameters for monitoring the jobs queue:

- `enabled`: Enable or disable the jobs monitor.
- `time_range_min`: The time range in minutes to consider for job counts.
- `max_jobs_per_queue`: The maximum allowed jobs per queue.
- `max_jobs_queue_len`: The maximum allowed total jobs count.
- `sqlite_db_path`: The path to the SQLite database file used for storing job statuses.
- `active_notification`: An array of notification channels to use when alerts are triggered.

### Usage

To run the monitoring the jobs queue, run the following Artisan command:

    php artisan txd:jobs-monitor


### Other commands

**Show the current jobs status (average in last minutes and current queue):**

    php artisan txd:jobs-status {--minutes= : Number of minutes to look back}

If Horizon is the default jobs manager, it lists all the available queues for the current environment with relatives totals.

Il database (and likely supervisor) is the default queue manager, it shows only queues extracted from current jobs/stats.

**Clear the current stats:**

    php artisan txd:jobs-monitor-clear-stats --type=[notifications | entries | all]

- `notification`: clear the current notification status
- `entries`: clear the current history jobs stats
- `all`: clear all the info gathered about jobs


### Tests

    composer install && \
        composer test

### TODO

- Different limit per queue
- Mail notification using Laravel default notification

### License

This package is open-source software licensed under the MIT license.