<?php

return [
    'enabled' => env('TXD_JOBS_MONITOR_ENABLED', false),

    'time_range_min' => 5, // minutes
    'max_jobs_queue_len' => 100, //number of total jobs allowed in the range. If null, no limit is set.
    'max_jobs_per_queue' => 10, //number of jobs allowed per queue in the range. If null, no limit is set.

    'sqlite_db_path' => storage_path('app/jobs_monitor.db'),

    'active_notification' => [
        'email' => true,
        'webhook' => false,
    ],

    'notifications' => [
        'email' => [
            'recipients' => env('TXD_JOBS_MONITOR_RECIPIENTS'), // comma separated list of email addresses
        ],
        'webhook' => [
            'url' => env('TXD_JOBS_MONITOR_WEBHOOK_URL'),
            'method' => 'POST',
            'headers' => [
                'Content-Type' => 'application/json',
            ],
        ],
    ],

];
