<?php

/*
|--------------------------------------------------------------------------
| Test Case
|--------------------------------------------------------------------------
|
| The closure you provide to your test functions is always bound to a specific PHPUnit test
| case class. By default, that class is "PHPUnit\Framework\TestCase". Of course, you may
| need to change it using the "pest()" function to bind a different classes or traits.
|
*/

// pest()->extend(Tests\TestCase::class)->in('Feature');

/*
|--------------------------------------------------------------------------
| Expectations
|--------------------------------------------------------------------------
|
| When you're writing tests, you often need to check that values meet certain conditions. The
| "expect()" function gives you access to a set of "expectations" methods that you can use
| to assert different things. Of course, you may extend the Expectation API at any time.
|
*/

use Tests\TestCase;
use Txd\JobsMonitor\Classes\JobsQueueMonitor;

expect()->extend('toBeOne', function () {
    return $this->toBe(1);
});

/*
|--------------------------------------------------------------------------
| Functions
|--------------------------------------------------------------------------
|
| While Pest is very powerful out-of-the-box, you may have some testing code specific to your
| project that you don't want to repeat in every file. Here you can also expose helpers as
| global functions to help you to reduce the number of lines of code in your test files.
|
*/

function something()
{
    // ..
}

uses(TestCase::class)->in(__DIR__);

function jobsQueueMonitor(): JobsQueueMonitor
{
    return app(JobsQueueMonitor::class);
}

function setupTestConfig()
{
    config([
        'txd_jobs_monitor' => [
            'enabled' => true,

            'time_range_min' => 5, // minutes
            'max_jobs_queue_len' => 10,
            'max_jobs_per_queue' => null,
            'stale_jobs_range' => 10,

            'sqlite_db_path' => storage_path('app/jobs_monitor.db'),

            'active_notification' => [
                'email' => true,
                'webhook' => false,
            ],

            'notifications' => [
                'email' => [
                    'recipients' => 'dest@example.com', // comma separated list of email addresses
                ],
                'webhook' => [
                    'url' => env('TXD_JOBS_MONITOR_WEBHOOK_URL'),
                    'method' => 'POST',
                    'headers' => [
                        'Content-Type' => 'application/json',
                    ],
                ],
            ],
        ],
        'queue' => [
            'default' => 'test',
        ],
    ]);
}
