<?php

namespace Txd\JobsMonitor\Commands;

use DB;
use Illuminate\Console\Command;
use Txd\JobsMonitor\Classes\JobsQueueMonitor;

class JobsQueueClearStatsCommand extends Command
{
    /** @var JobsQueueMonitor */
    protected $jobsQueueMonitor;

    protected $signature = 'txd:jobs-monitor-clear-stats {--type= : Type of stats to clear (all, notifications, entries)}';

    protected $description = 'Clear jobs queue stats';

    public function __construct(JobsQueueMonitor $jobsQueueMonitor)
    {
        parent::__construct();

        $this->jobsQueueMonitor = $jobsQueueMonitor;
    }

    /**
     * @return \Illuminate\Console\View\Components\Factory|self
     */
    protected function console_write()
    {
        if (property_exists($this, 'components') && is_a($this->{'components'}, 'Illuminate\Console\View\Components\Factory')) {
            /** @var \Illuminate\Console\View\Components\Factory $callable_message_component */
            $callable_message_component = $this->{'components'};
        } else {
            /** @var self $callable_message_component */
            $callable_message_component = $this;
        }

        return $callable_message_component;
    }

    public function handle()
    {
        if (! config('txd_jobs_monitor.enabled')) {
            $this->console_write()->info('Jobs monitor is disabled');

            return;
        }

        $type = $this->option('type');

        $clear_all = false;
        $clear_notifications = false;
        $clear_entries = false;

        switch ($type) {
            case 'all':
                $clear_all = true;
                break;
            case 'notifications':
                $clear_notifications = true;
                break;
            case 'entries':
                $clear_entries = true;
                break;
            default:
                $this->console_write()->error('Invalid type of stats to clear');
        }

        $this->jobsQueueMonitor->initJobsMonitorStatsDB();

        if ($clear_all) {
            $this->console_write()->warn('Recreating stats database');
            $this->jobsQueueMonitor->initJobsMonitorStatsDB($clear_all);
        }

        if ($clear_notifications) {
            $this->console_write()->warn('Deleting notifications');
            DB::connection('txd_jobs_sqlite')->table('notifications')->truncate();
        }

        if ($clear_entries) {
            $this->console_write()->warn('Deleting entries');
            DB::connection('txd_jobs_sqlite')->table('queue_job_status')->truncate();
        }

    }
}
