<?php

namespace Txd\JobsMonitor\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Throwable;

class NotificationMail extends Mailable
{
    use Queueable, SerializesModels;

    protected $html_text;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($subject = null, $html_text = null)
    {
        $this->subject = $subject ?? 'Email subject';
        $this->html_text = $html_text ?? '<p>Content of the e-mail!</p>';
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {

        try {
            $html_obj = new \Html2Text\Html2Text(view('txd::jobsMonitor.notification_mail', ['subject' => $this->subject, 'html_text' => $this->html_text])->render());
            $plain_message = $html_obj->getText();
        } catch (Throwable $ex) {
            Log::warning(__METHOD__.' | '.$ex->getMessage());
            $plain_message = strip_tags(html_entity_decode(view('txd::jobsMonitor.notification_mail', ['subject' => $this->subject, 'html_text' => $this->html_text])->render()));
        }

        $email = $this
            ->text('txd::jobsMonitor.notification_mail_plaintext')
            ->view('txd::jobsMonitor.notification_mail')
            ->with([
                'subject' => $this->subject,
                'html_text' => $this->html_text,
                'plaintext_message' => $plain_message,
            ])
            ->subject($this->subject);

        return $email;
    }
}
