<?php

namespace Txd\JobsMonitor\Provider;

use Illuminate\Support\ServiceProvider;
use Txd\JobsMonitor\Commands\JobsQueueClearStatsCommand;
use Txd\JobsMonitor\Commands\JobsQueueMonitorCommand;
use Txd\JobsMonitor\Commands\JobsQueueStatusCommand;

class PackageServiceProvider extends ServiceProvider
{
    public function register()
    {
        // Register any package-specific services here
    }

    public function boot()
    {

        $this->publishes([
            __DIR__.'/../views/jobsMonitor' => base_path('resources/views/vendor/txd/jobsMonitor'),
        ], 'txd_jobsMonitor:views');

        $this->publishes([
            __DIR__.'/../../config/txd_jobs_monitor.php' => config_path('txd_jobs_monitor.php'),
        ], 'txd_jobsMonitor:config');

        $this->mergeConfigFrom(
            __DIR__.'/../../config/txd_jobs_monitor.php', 'txd_jobs_monitor'
        );

        if ($this->app->runningInConsole()) {
            $this->commands([
                JobsQueueMonitorCommand::class,
                JobsQueueClearStatsCommand::class,
                JobsQueueStatusCommand::class,
            ]);
        }

        //caricamento namespace per view
        $this->loadViewsFrom(base_path('resources/views/vendor/txd'), 'txd');
        $this->loadViewsFrom(__DIR__.'/../views', 'txd');

        initDbConfig();

    }
}
