<?php

namespace Txd\Layout;

use Illuminate\Contracts\Support\Htmlable;
use Illuminate\Contracts\Support\Renderable;

class TxdCard extends Container
{
    protected ?Actions $actions = null;

    public function __construct(array $contents, public null|string|Htmlable|Renderable $title = null, public null|string|Htmlable|Renderable $footer = null)
    {
        parent::__construct($contents);
        $this->htmlProperties()->addHtmlClass(['card']);
    }

    public function setTitle(null|string|Htmlable|Renderable $title)
    {
        $this->title = $title;

        return $this;
    }

    public function setFooter(null|string|Htmlable|Renderable $footer)
    {
        $this->footer = $footer;

        return $this;
    }

    public function actions()
    {
        if (is_null($this->actions)) {
            $this->actions = new Actions;
        }

        return $this->actions;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {

        $propertiesString = $this->htmlProperties()->renderHtmlProperties();

        return view('components.card_htmlable', [
            'cardProps' => $propertiesString,
            'contents' => collect($this->contents)->map(fn ($el) => prepareLayoutContent($el)),
            'title' => prepareLayoutContent($this->title),
            'footer' => prepareLayoutContent($this->footer),
            'actions' => $this->actions ?? '',
        ])->render();

    }
}
