<?php

namespace Txd\Layout;

use Illuminate\Contracts\Support\Htmlable;

class Actions extends Container
{
    /**
     * Create a new component instance.
     */
    public function __construct(array $contents = [], ?string $class = null)
    {
        if ($class) {
            $this->htmlProperties()->addHtmlClass($class);
        }
    }

    public function addAction(string $key, callable|string|Htmlable $function, $position = -1)
    {
        return $this->addActions([$key => $function], $position);
    }

    public function addActions(array $functions, $position = -1)
    {
        if ($position < 0) {
            $position = count($this->contents);
        }
        array_splice($this->contents, $position, 0, $functions);

        return $this;
    }

    public function removeAction(string $key)
    {
        unset($this->contents[$key]);

        return $this;
    }

    public function elements()
    {
        return $this->contents;
    }
}
