<?php

namespace Txd\Layout;

class VueTag extends Container
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    public function __construct(public string $tag) {}

    public function addProp(string $name, $value)
    {
        $snakeName = \Illuminate\Support\Str::kebab($name);
        $this->htmlProperties()->addHtmlAttribute("data-$snakeName", $value);

        return $this;
    }

    public function addProps(array $props)
    {
        foreach ($props as $name => $value) {
            $this->addProp($name, $value);
        }

        return $this;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {

        $propertiesString = $this->htmlProperties()->renderHtmlProperties();
        $content = collect($this->contents)->map(fn ($el) => (string) prepareLayoutContent($el))->join('');
        $tag = $this->tag;

        return "<$tag $propertiesString >$content</$tag>";
    }
}
