<?php

use Illuminate\Contracts\Support\Htmlable;
use Illuminate\Contracts\Support\Renderable;

if (!function_exists('htmlString')) {
    function htmlString($content)
    {
        return new Illuminate\Support\HtmlString($content);
    }
}

if (!function_exists('prepareLayoutContent')) {
    function prepareLayoutContent(null|string|callable|Htmlable|Renderable $content): null|string|Htmlable
    {
        $partial = is_callable($content) ? $content() : $content;

        return is_a($partial, Renderable::class) ? htmlString($partial->render()) : $partial;
    }
}
