<?php

namespace Txd\Provider;

use Illuminate\Support\ServiceProvider;


/**
 *  *
 * @author Fabio Spadea <fabio@techseed.it>
 */
class LayoutServiceProvider extends ServiceProvider
{
    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {
        $this->publishes([
            __DIR__.'/config/txd_layout.php' => config_path('txd_layout.php'),
        ], 'txd_layout:config');

        $this->publishes([
            __DIR__.'/../views/Layout' => base_path('resources/views/vendor/txd/Layout'),
        ], 'txd_layout:views');

        $this->mergeConfigFrom(
            __DIR__.'/../config/txd_layout.php', 'txd_layout'
        );

        $this->loadTranslationsFrom(__DIR__.'/../lang', 'txd');
        $this->publishes([
            __DIR__.'/../lang' => $this->app->langPath('vendor/txd'),
        ]);

        //caricamento namespace per view
        $this->loadViewsFrom(base_path('resources/views/vendor/txd'), 'txd');
        $this->loadViewsFrom(__DIR__.'/../views', 'txd');
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
    
    }

    

    
}
