<?php

namespace Txd\Layout;

use Illuminate\Contracts\Support\Htmlable;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\View\Component;
use Txd\Traits\HtmlPropertiesTrait;

class Container extends Component implements Htmlable
{
    use HtmlPropertiesTrait;

    /**
     * @param  array<null|string|callable|Htmlable|Renderable>  $contents
     * @return void
     */
    public function __construct(public array $contents = [], protected string $tag ="div") {}

    /**
     * @param  array<null|string|callable|Htmlable|Renderable>  $contents
     * @return $this
     */
    public function setContents(array $contents)
    {
        $this->contents = $contents;

        return $this;
    }
    
    public function setTag(string $tag)
    {
        $this->tag = $tag;

        return $this;
    }

    /**
     * @return array<string|int, null|string|callable|\Illuminate\Contracts\Support\Htmlable|\App\View\Components\Renderable>
     */
    public function getContents()
    {
        return $this->contents;
    }

    /**
     * @param  null|string|callable|Htmlable|Renderable  ...$contents
     * @return $this
     */
    public function addContents(...$contents)
    {
        foreach ($contents as $v) {
            $this->contents[] = $v;

        }

        return $this;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {

        $propertiesString = $this->htmlProperties()->renderHtmlProperties();
        $content = collect($this->contents)->map(fn ($el) => (string) prepareLayoutContent($el))->join('');
        $tag = $this->tag;
        return "<$tag $propertiesString >$content</$tag>";

    }

    public function __toString()
    {
        return $this->render();
    }

    public function toHtml()
    {
        return $this->render();
    }
}
