<?php

namespace Txd\OpcacheReset\Provider;

use Illuminate\Support\ServiceProvider;
use Txd\OpcacheReset\Commands\OpcacheReset;
use Txd\OpcacheReset\Http\Middleware\LocalhostOnly;

class PackageServiceProvider extends ServiceProvider
{
    public function register()
    {
        // Register any package-specific services here
    }

    public function boot()
    {
        $this->loadRoutesFrom(__DIR__.'/../routes.php');
        $this->app['router']->aliasMiddleware('localhost', LocalhostOnly::class);

        if ($this->app->runningInConsole()) {
            $this->commands([
                OpcacheReset::class,
            ]);
        }
    }
}
