<?php

namespace Txd\OpcacheReset\Commands;

use GuzzleHttp\Client;
use Illuminate\Console\Command;

class OpcacheReset extends Command
{
    protected $signature = 'opcache:reset';
    protected $description = 'Reset OPCache via HTTP request.';

    public function handle()
    {
        $client = new Client();
        try {
            $response = $client->request('GET', 'http://127.0.0.1/opcache_reset');
            $this->info('Response: ' . $response->getBody());
        } catch (\Exception $e) {
            $this->error('Error: ' . $e->getMessage());
        }
    }
}
