# txdOPCache Package

A Laravel package designed to securely reset OPCache via a middleware-protected route and a custom Artisan command. This allows for secure and efficient management of OPCache clearing, suitable for environments where direct CLI access might be limited.
## Installation

To install the package via Composer, run the following command:

    composer require txd/opcache

## Usage

### Secure OPCache Reset Route

The package adds a secure route that is only accessible from the localhost. This route can be used to reset the OPCache:

    GET /opcache_reset

This route is protected by the LocalhostOnly middleware to ensure it is accessible only from 127.0.0.1 or ::1.

### Custom Artisan Command

You can also reset OPCache using the provided Artisan command, which makes an HTTP request to the secure route:

    php artisan opcache

This command is useful for integrating OPCache management into deployment scripts or other automated processes.

### License

This package is open-source software licensed under the MIT license.