<?php

namespace Txd\OpcacheReset\Commands;

use GuzzleHttp\Client;
use Illuminate\Console\Command;

class OpcacheResetCommand extends Command
{
    protected $signature = 'opcache:reset';

    protected $description = 'Reset OPCache via HTTP request.';

    public function handle()
    {
        if (property_exists($this, 'components') && is_a($this->{'components'}, 'Illuminate\Console\View\Components\Factory')) {
            /** @var \Illuminate\Console\View\Components\Factory $callable_message_component */
            $callable_message_component = $this->{'components'};
        } else {
            /** @var self $callable_message_component */
            $callable_message_component = $this;
        }

        $client = new Client;
        $callable_message_component->warn('Resetting OPCache...');
        try {
            $response = $client->request('GET', 'http://127.0.0.1/opcache_reset');
            $callable_message_component->info($response->getBody());
        } catch (\Exception $e) {
            $callable_message_component->error($e->getMessage());
        }
    }
}
